/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt.stream;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundMap;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.DoubleTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.EndTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.FloatTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.StringTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;
import net.creeperhost.ftbbackups.de.piegames.nbt.stream.LittleEndianInputStream;

public final class NBTInputStream
implements Closeable {
    public static final int NO_COMPRESSION = 0;
    public static final int GZIP_COMPRESSION = 1;
    public static final int ZLIB_COMPRESSION = 2;
    private final DataInput dataIn;
    private final InputStream inputStream;
    private boolean rawArrays = true;

    public NBTInputStream(InputStream is) throws IOException {
        this(is, 1, ByteOrder.BIG_ENDIAN);
    }

    public NBTInputStream(InputStream is, int compression) throws IOException {
        this(is, compression, ByteOrder.BIG_ENDIAN);
    }

    public NBTInputStream(InputStream is, int compression, boolean rawArrays) throws IOException {
        this(is, compression, rawArrays, ByteOrder.BIG_ENDIAN);
    }

    public NBTInputStream(InputStream is, int compression, ByteOrder endianness) throws IOException {
        this(is, compression, false, endianness);
    }

    public NBTInputStream(InputStream is, int compression, boolean rawArrays, ByteOrder endianness) throws IOException {
        switch (compression) {
            case 0: {
                break;
            }
            case 1: {
                is = new GZIPInputStream(is);
                break;
            }
            case 2: {
                is = new InflaterInputStream(is);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported compression type, must be between 0 and 2 (inclusive)");
            }
        }
        if (endianness == ByteOrder.LITTLE_ENDIAN) {
            this.dataIn = new LittleEndianInputStream(is);
            this.inputStream = (InputStream)((Object)this.dataIn);
        } else {
            this.dataIn = new DataInputStream(is);
            this.inputStream = (InputStream)((Object)this.dataIn);
        }
        this.rawArrays = rawArrays;
    }

    public Tag<?> readTag() throws IOException {
        return this.readTag(0);
    }

    private Tag<?> readTag(int depth) throws IOException {
        int typeId = this.dataIn.readByte() & 0xFF;
        TagType type = TagType.getById(typeId);
        String name = type != TagType.TAG_END ? this.dataIn.readUTF() : "";
        return this.readTagPayload(type, name, depth);
    }

    private Tag readTagPayload(TagType type, String name, int depth) throws IOException {
        switch (type) {
            case TAG_END: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case TAG_BYTE: {
                return new ByteTag(name, this.dataIn.readByte());
            }
            case TAG_SHORT: {
                return new ShortTag(name, this.dataIn.readShort());
            }
            case TAG_INT: {
                return new IntTag(name, this.dataIn.readInt());
            }
            case TAG_LONG: {
                return new LongTag(name, this.dataIn.readLong());
            }
            case TAG_FLOAT: {
                return new FloatTag(name, this.dataIn.readFloat());
            }
            case TAG_DOUBLE: {
                return new DoubleTag(name, this.dataIn.readDouble());
            }
            case TAG_STRING: {
                return new StringTag(name, this.dataIn.readUTF());
            }
            case TAG_LIST: {
                TagType childType = TagType.getById(this.dataIn.readByte());
                int length = this.dataIn.readInt();
                if (childType == TagType.TAG_END && length > 0) {
                    throw new IOException("TAG_End not permitted in a list.");
                }
                ArrayList<Tag> tagList = new ArrayList<Tag>(length);
                for (int i = 0; i < length; ++i) {
                    tagList.add(this.readTagPayload(childType, "", depth + 1));
                }
                if (this.rawArrays && (childType == TagType.TAG_SHORT_ARRAY || childType == TagType.TAG_INT_ARRAY || childType == TagType.TAG_LONG_ARRAY)) {
                    childType = TagType.TAG_BYTE_ARRAY;
                }
                return new ListTag(name, childType, tagList);
            }
            case TAG_COMPOUND: {
                Tag<?> tag;
                CompoundMap compoundTagList = new CompoundMap();
                while (!((tag = this.readTag(depth + 1)) instanceof EndTag)) {
                    compoundTagList.put(tag);
                }
                return new CompoundTag(name, compoundTagList);
            }
            case TAG_INT_ARRAY: {
                if (!this.rawArrays) {
                    int length = this.dataIn.readInt();
                    int[] ints = new int[length];
                    for (int i = 0; i < length; ++i) {
                        ints[i] = this.dataIn.readInt();
                    }
                    return new IntArrayTag(name, ints);
                }
            }
            case TAG_LONG_ARRAY: {
                if (!this.rawArrays) {
                    int length = this.dataIn.readInt();
                    long[] longs = new long[length];
                    for (int i = 0; i < length; ++i) {
                        longs[i] = this.dataIn.readLong();
                    }
                    return new LongArrayTag(name, longs);
                }
            }
            case TAG_SHORT_ARRAY: {
                if (!this.rawArrays) {
                    int length = this.dataIn.readInt();
                    short[] shorts = new short[length];
                    for (int i = 0; i < length; ++i) {
                        shorts[i] = this.dataIn.readShort();
                    }
                    return new ShortArrayTag(name, shorts);
                }
            }
            case TAG_BYTE_ARRAY: {
                int length = this.dataIn.readInt() * type.getSize();
                byte[] bytes = new byte[length];
                this.dataIn.readFully(bytes);
                return new ByteArrayTag(name, bytes);
            }
        }
        throw new IOException("Invalid tag type: " + (Object)((Object)type) + ".");
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

